/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap;

import java.io.File;
import java.io.IOException;
import org.apache.nifi.bootstrap.RunNiFi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsService {
    public static final String DEFAULT_CONFIG_FILE = "./conf/bootstrap.conf";
    private static final Logger commandLogger = LoggerFactory.getLogger((String)"org.apache.nifi.bootstrap.Command");
    private static final File bootstrapConfigFile = WindowsService.getBootstrapConfFile();
    private static RunNiFi bootstrap;

    public static void start(String[] args) throws IOException, InterruptedException {
        boolean verbose = WindowsService.isVerbose(args);
        commandLogger.info("WindowsService-Starting NiFi");
        bootstrap = new RunNiFi(WindowsService.getBootstrapConfFile());
        bootstrap.start(true);
        commandLogger.info("WindowsService-NiFi run method exiting.");
    }

    public static void stop(String[] args) throws IOException, InterruptedException {
        commandLogger.info("WindowsService-Stopping NiFi");
        bootstrap.setAutoRestartNiFi(false);
        bootstrap.stop();
        commandLogger.info("WindowsService-NiFi stop process completed.");
    }

    private static boolean isVerbose(String[] args) {
        return args.length == 1 && args[0].equalsIgnoreCase("-verbose");
    }

    private static File getBootstrapConfFile() {
        String nifiHome;
        String configFilename = System.getProperty("org.apache.nifi.bootstrap.config.file");
        if (configFilename == null && (nifiHome = System.getenv("NIFI_HOME")) != null) {
            File nifiHomeFile = new File(nifiHome.trim());
            File configFile = new File(nifiHomeFile, DEFAULT_CONFIG_FILE);
            configFilename = configFile.getAbsolutePath();
        }
        if (configFilename == null) {
            configFilename = DEFAULT_CONFIG_FILE;
        }
        File configFile = new File(configFilename);
        return configFile;
    }
}

